<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Meta Tag -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo (isset($mataTitle)) ? $mataTitle.' | ': ''; ?> <?php echo $details['site_name'] ?></title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="<?php echo (isset($mata_description) ? $mata_description : '') ?> <?php echo (empty($details) ? '' : $details['site_description']) ?>">
    <meta name="keywords" content="<?php echo (empty($details) ? '' : $details['site_keywords']) ?>">
    

    <meta property="og:title" content="<?php echo (isset($mataTitle)) ? $mataTitle.' | ': ''; ?> <?php echo $details['site_name'] ?>">
    <meta property="og:description" content="<?php echo (isset($mata_description) ? $mata_description : '') ?> <?php echo (empty($details) ? '' : $details['site_description']) ?>">
    <meta property="og:image" content="<?php echo $details['web_logo_1'] ?>">
    <meta property="og:url" content="<?php echo current_url() ?>">
    <meta property="og:type" content="website">
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo (isset($mataTitle)) ? $mataTitle.' | ': ''; ?> <?php echo $details['site_name'] ?>">
    <meta name="twitter:description" content="<?php echo (isset($mata_description) ? $mata_description : '') ?> <?php echo (empty($details) ? '' : $details['site_description']) ?>">
    <meta name="twitter:image" content="<?php echo $details['web_logo_1'] ?>">

    <!-- Favicon -->
    <link href="<?php echo $details['web_favicon'] ?>" rel="icon">
    
    <!-- IOS Touch Icons -->
    <link rel="apple-touch-icon" href="<?php echo $details['web_favicon'] ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo $details['web_favicon'] ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo $details['web_favicon'] ?>">
    <link rel="apple-touch-icon" sizes="167x167" href="<?php echo $details['web_favicon'] ?>">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@300;400;500;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link rel="stylesheet" href="<?= base_url('css/plugins.bundle.css?v=3.0.0') ?>" type="text/css">
    <link rel="stylesheet" href="<?= base_url('css/styles.bundle.css?v=3.0.0') ?>" type="text/css">
    
    <!-- Global Base URL -->
    <script>var base_url = '<?php echo base_url() ?>';</script>
    
    <?= html_entity_decode((empty($details) ? '' : $details['header_code'])); ?>
    
</head>
<style>
    #line_loader {
        z-index: 9909;
    }
    .cta {
      position: relative;
      margin: auto;
      padding: 8px 18px;
      transition: all 0.2s ease;
      border: none;
      background: none;
      cursor: pointer;
    }
    
    .cta:before {
      content: "";
      position: absolute;
      top: 0;
      left: 0;
      display: block;
      border-radius: 50px;
      background: linear-gradient(45deg, rgba(234,11,66,1) 0%, rgba(236,3,117,1) 100%);
      width: 45px;
      height: 45px;
      transition: all 0.3s ease;
    }
    
    .cta span {
      position: relative;
      font-size: 18px;
      font-weight: 700;
      letter-spacing: 0.05em;
      color: #000000;
    }
    
    .cta i {
      position: relative;
      top: 0;
      margin-left: 8px;
      color: #000000;
      transform: translateX(-5px);
      transition: all 0.3s ease;
    }
    
    .cta:hover:before {
      width: 100%;
      background: linear-gradient(45deg, rgba(234,11,66,1) 0%, rgba(236,3,117,1) 100%);
    }
    
    .cta:hover i {
      transform: translateX(0);
    }
    
    .cta:active {
      transform: scale(0.95);
    }
    
    body[data-theme="dark"] .cta span {
      color: #ffffff;
    }
    
    body[data-theme="dark"] .cta i {
      color: #ffffff;
    }
    
    .card {
        border-radius: var(--cover-border-radius) !important;
    }
</style>
<body>

    <div id="line_loader"></div>

    <div id="loader">
        <div>
            <span class="navbar-brand-text"><?php echo $details['site_name'] ?></span>
            <div id="loader_progress"></div>
        </div>
    </div>
    
    <div id="main">
        <!-- Start:: header -->
        <header id="header">
            <div class="header-top">
                <div class="container">
                    <nav class="navbar py-0">
                        <button class="navbar-toggler me-3 d-lg-none" type="button" data-bs-toggle="collapse" data-bs-target="#main_navbar" aria-controls="main_navbar" aria-expanded="false" aria-label="Toggle navigation">
                            <i class="ri-menu-fill"></i>
                        </button>
                        <a class="navbar-brand d-flex align-items-center py-0" href="<?= base_url() ?>" aria-label="<?php echo $details['site_name'] ?>">
                            <img src="<?php echo $details['web_logo_1'] ?>" alt="" style="width: 30px; margin-right: 10px;" >
                            <span class="navbar-brand-text"><?php echo $details['site_name'] ?></span>
                        </a>
                        <ul class="navbar-nav flex-row ms-auto">
                            <li class="nav-item me-2">
                                <a href="<?= base_url('add-suggestion') ?>" class="btn btn-icon btn-sm btn-default rounded-pill">
                                    <i class="ri-add-fill"></i>
                                </a>
                            </li>
                            <li class="nav-item me-2">
                                <a href="javascript:void(0);" id="dark_mode" class="btn btn-icon btn-sm btn-default rounded-pill">
                                    <i class="ri-moon-fill icon-dark"></i>
                                    <i class="ri-sun-fill icon-light"></i>
                                </a>
                            </li>
                            <?php if(\App\Libraries\CIAuth::check()){ ?>
                                <li class="nav-item me-2">
                                    <a href="<?php echo base_url('profile');?>" class="btn btn-icon btn-sm btn-default rounded-pill">
                                        <i class="ri-user-6-fill"></i>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="<?php echo base_url('login/logout');?>" class="btn btn-icon btn-sm btn-default rounded-pill">
                                        <i class="ri-logout-box-line p-2"></i>
                                    </a>
                                </li>
                            <?php } else { ?>
                                <li class="nav-item">
                                    <a href="<?php echo base_url('login');?>" class="btn btn-icon btn-sm btn-default rounded-pill">
                                        <i class="ri-login-box-line p-2"></i>
                                    </a>
                                </li>
                            <?php } ?>
                            
                        </ul>
                    </nav>
                </div>
            </div>
            <div class="header-bottom navbar-expand-lg">
                <div class="container py-2 py-lg-0">
                    <nav class="navbar">
                        <div class="collapse navbar-collapse" id="main_navbar">
                            <ul class="navbar-nav mb-3 mb-lg-0">
                                <li class="nav-item">
                                    <a class="nav-link d-flex align-items-center <?php if($menu_active=="discover"){?>active<?php }?>" href="<?= base_url() ?>"><i class="ri-home-3-line nav-icon"></i>Discover</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link d-flex align-items-center <?php if($menu_active=="radios"){?>active<?php }?>" href="<?= base_url('latest-radios') ?>"><i class="ri-list-unordered nav-icon"></i>Radios</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link d-flex align-items-center <?php if($menu_active=="categories"){?>active<?php }?>" href="<?= base_url('categories') ?>"><i class="ri-folder-3-line nav-icon"></i>Categories</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link d-flex align-items-center <?php if($menu_active=="countries"){?>active<?php }?>" href="<?= base_url('countries') ?>"><i class="ri-earth-line nav-icon"></i>Countries</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link d-flex align-items-center <?php if($menu_active=="podcast"){?>active<?php }?>" href="<?= base_url('podcast') ?>"><i class="ri-disc-line nav-icon"></i>Podcast</a>
                                </li>
                                <li class="nav-item has-menu">
                                    <a class="nav-link <?php if($menu_active=="about" or $menu_active=="policy" or $menu_active=="terms"){?>active<?php }?>">More</a>
                                    <ul class="navbar-nav submenu">
                                        <li class="nav-item">
                                            <a class="nav-link d-flex align-items-center <?php if($menu_active=="about"){?>active<?php }?>" href="<?= base_url('about-us') ?>"><i class="ri-user-3-line nav-icon"></i>About us</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link <?php if($menu_active=="policy"){?>active<?php }?>" href="<?= base_url('privacy-policy') ?>"><i class="ri-git-repository-private-line nav-icon"></i>Privacy Policy</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link <?php if($menu_active=="terms"){?>active<?php }?>" href="<?= base_url('terms-condition') ?>"><i class="ri-information-line nav-icon"></i>Terms Condition</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                        <div class="search ps-lg-3" role="search">
                            <input type="text" id="pb-search-input" class="form-control rounded-pill" placeholder="Search your favorites...">
                            <button type="button" class="btn" id="pb_search_icon">
                                <i class="ri-search-2-line"></i>
                            </button>
                        </div>
                    </nav>
                </div>
            </div>
        </header>
        <!-- End:: header -->